/* 
* Name    : AGC_LIB 
* Complie : VC2005  
* Ver     : 2010/03/30

Ver. 1.0 Initial released for AR-B104D GPIO/SRAM access

*/
#include "stdafx.h"
#ifdef _MANAGED
#pragma managed(push, off)
#endif

#include "AGC_LIB.h"
#include <winioctl.h>
#include <windows.h>
#pragma comment(lib,"user32.lib")
#include <stdio.h>
#include "Ioctls.h"
#include "ERRCODE.H"

u32  VendorID,DeviceID;//VID PID 
unsigned long SubsystemID;      //SubsystemID reg
u32  SubID;		    //Subsysten ID
unsigned long VPID = 0;		    //VID + PID 

static void InterruptThread(void* arg);

typedef struct
{
  HANDLE drv_handle;
  BOOL is_device_open;
  BOOL is_thread_start;
  BOOL is_thread_end;
  agc_callback_t CallBackFunc;
  event Event;
} DEVINFO;

static DEVINFO DevInfo[MAX_DEV];

BOOL APIENTRY DllMain(HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
  UNREFERENCED_PARAMETER(hModule);
  UNREFERENCED_PARAMETER(lpReserved);
  BOOL Result = TRUE;
  switch (ul_reason_for_call)
  {
  case DLL_PROCESS_ATTACH:
    {
      break;
    }
  case DLL_THREAD_ATTACH:
    break;		
  case DLL_THREAD_DETACH:
    break;
  case DLL_PROCESS_DETACH:
    {
      break;
    }
  }
  return Result;
}
//////////////////////////////////
// u32 WXP_Io_Read_Byte(u32 address,u8* data);
// u32 WXP_Io_Read_Word(u32 address,u16* data);
// u32 WXP_Io_Read_Dword(u32 address,unsigned long* data);

// u32 WXP_Io_Write_Byte(u32 address,u8 data);
// u32 WXP_Io_Write_Word(u32 address,u16 data);
// u32 WXP_Io_Write_Dword(u32 address,unsigned long data);

// u32 WXP_Mem_Read_Byte(unsigned long address, u8* data);
// u32 WXP_Mem_Read_Word(unsigned long address, u16* data);
// u32 WXP_Mem_Read_Dword(unsigned long address, unsigned long* data);

// u32 WXP_Mem_Write_Byte(unsigned long address, u8 data);
// u32 WXP_Mem_Write_Word(unsigned long address, u16 data);
// u32 WXP_Mem_Write_Dword(unsigned long address, unsigned long data);
/*****************************************************************************************************************/
/*                                               FOR AGC PCI FUN                                                 */
/*****************************************************************************************************************/
/////////////////////////////////////////
//FOR Interrupt 
//INPUT  : 
//OUTPUT Interrupt
////////////////////////////////////////
static void InterruptThread(void* arg)
{
  IO_ACCESS ioAcce;
  DWORD BytesReturned;
  u16 type;
  DEVINFO* DevInfo = (DEVINFO*)arg;
  DevInfo->is_thread_start = TRUE;
  while (1)
  {
    /* Callback function */
    if (DevInfo->is_thread_end)
    break;
    //io callback
    if(DeviceIoControl(DevInfo->drv_handle,ARBIOC_GET_CONT, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL))
    if(ioAcce.value.word !=0)
    if(DeviceIoControl(DevInfo->drv_handle, ARBIOC_GET_BUFF, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL))
    {
      if(DevInfo->CallBackFunc != NULL)
      {
        type = (u16)((ioAcce.value.dword) >> 16);
        if( type < INPUT_NO )
        {
          DevInfo->Event.Type = INPUT;
          DevInfo->Event.Channel = type;
        } else if( type < (INPUT_NO+OUTPUT_NO) )
        {
          DevInfo->Event.Type = PG_FIN;
          DevInfo->Event.Channel = type - INPUT_NO;
        } else if( type < (INPUT_NO+OUTPUT_NO+TIMER_NO) )
        {
          DevInfo->Event.Type = TIMER_FIN;
          DevInfo->Event.Channel = type - (INPUT_NO+OUTPUT_NO);
        } else if( type < 200 )
        {
          DevInfo->Event.Type = COUNTER_OF;
          DevInfo->Event.Channel = type - 100;
        } else if( type < 300 )
        {
          DevInfo->Event.Type = COUNTER_TO;
          DevInfo->Event.Channel = type - 200;
        } else
        {
          DevInfo->Event.Type = COUNTER_REACH;
          DevInfo->Event.Channel = type - 300;
        }
        DevInfo->Event.Value = (u16)(ioAcce.value.dword & 0xFFFF);
        DevInfo->CallBackFunc(DevInfo->Event);
      }
    }
    Sleep(10);						// Delay & Task Switch
  } //while
  DevInfo->is_thread_start = FALSE;
}

/*
*  REGISTERCARD FUN FOR switch cardnumber 
*  INPUT  : CARDNUM
*  Install Define Setup
*/
AGC_API unsigned int APIENTRY WXP_RegisterCard(i16 *CardNum)
{
  HANDLE hARBPort;
  if(INVALID_HANDLE_VALUE == (hARBPort=CreateFileA("\\\\.\\ARB104D0", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)))
  if(INVALID_HANDLE_VALUE == (hARBPort=CreateFileA("\\\\.\\ARB104D1", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)))
  if(INVALID_HANDLE_VALUE == (hARBPort=CreateFileA("\\\\.\\ARB104D2", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)))
  hARBPort=CreateFileA("\\\\.\\ARB104D3", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

  DevInfo[(*CardNum)].drv_handle = hARBPort;
  if (hARBPort == INVALID_HANDLE_VALUE)
  {
    (*CardNum) = (i16)0xffff;
    MessageBoxA(NULL, "Couldn't access AGC Driver,\n Please ensure driver is loaded.\n", "AGC-DLL", MB_ICONINFORMATION);
    DevInfo[(*CardNum)].is_device_open = FALSE;
    return ERRMSG(ERROR_API_REGISTERCARD,ERROR_GEN_DRIVER_OPEN);
  }
  DevInfo[(*CardNum)].is_device_open = TRUE;
  DevInfo[(*CardNum)].is_thread_start = FALSE;
  DevInfo[(*CardNum)].is_thread_end = FALSE;

  return ERROR_API_SUCC;
}

/*
* FOR Release Card 
* INPUT  : IO ADDRESS 
* OUTPTU : ERROR CODE
*/
AGC_API unsigned int APIENTRY WXP_ReleaseCard(i16 CardNum)
{
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_RELEASECARD,ERROR_GEN_DEVICE_NUM);// Not vlaid card number
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_RELEASECARD,ERROR_GEN_DEVICE_OPEN);// Device not open
  if (DevInfo[CardNum].is_thread_start)
  {
    DevInfo[CardNum].is_thread_end = TRUE;
    while(DevInfo[CardNum].is_thread_start == TRUE) 
    {
      Sleep(10);
    }
  }
  CloseHandle(DevInfo[CardNum].drv_handle);
  DevInfo[CardNum].is_device_open = FALSE;
  return ERROR_API_SUCC;
}

/*
* For Read Mem address
* OUTDATA  :  MEMORY ADDRESS
*/
AGC_API unsigned int APIENTRY WXP_GetMemBaseAddr(i16 CardNum, u32* MemBaseAddr)
{
  BOOL error;
  IO_ACCESS ioAcce;
  char szt[255];
  DWORD BytesReturned;

  if ((CardNum < 0) || (CardNum >= MAX_DEV))
  return ERRMSG(ERROR_API_GETMEMBASEADDR,ERROR_GEN_DEVICE_NUM); 

  if (DevInfo[CardNum].is_device_open == FALSE)
  return ERRMSG(ERROR_API_GETMEMBASEADDR,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = MEMBASE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_CFR_DWRD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
  {
    wsprintfA(szt, "Error occured during outportb while talking to AGC driver %d\n", GetLastError());
    MessageBoxA(NULL, szt, "AGC-DLL", MB_ICONINFORMATION);//for pri32 message box
    return ERRMSG(ERROR_API_GETMEMBASEADDR,ERROR_GEN_DEVICE_FAIL);
  }
  else                                                              
  {																  
    (*MemBaseAddr) = ioAcce.value.dword;
    return ERROR_API_SUCC;                                        
  }                                                                 
}

/*
*For GET I/O BASE ADDRESS 
*INPUT  : IO ADDRESS , IO BASE ADDRESS 
*OUTPUT : ERROR CODE
*/
AGC_API unsigned int APIENTRY WXP_GetIOBaseAddr(i16 CardNum, u32* IOBaseAddr)
{
  BOOL error;
  IO_ACCESS ioAcce;
  char szt[255];
  DWORD BytesReturned;

  if ((CardNum < 0) || (CardNum >= MAX_DEV))
  return ERRMSG(ERROR_API_GETIOBASEADDR,ERROR_GEN_DEVICE_NUM); 

  if (DevInfo[CardNum].is_device_open == FALSE)
  return ERRMSG(ERROR_API_GETIOBASEADDR,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = IOBASE;//0x14
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_CFR_DWRD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);

  if (!error)
  {
    wsprintfA(szt, "Error occured during outportb while talking to AGC driver %d\n", GetLastError());//r
    MessageBoxA(NULL, szt, "AGC-DLL", MB_ICONINFORMATION);
    return ERRMSG(ERROR_API_GETIOBASEADDR,ERROR_GEN_DEVICE_FAIL);     
  }
  else											  			
  {												  			
    (*IOBaseAddr) = (ioAcce.value.dword);
    (*IOBaseAddr) &= 0xfffe;
  }  
  return ERROR_API_SUCC;
}
#define MEMSIZE 0x100000 
/////////////////////////////////////////////////////////////////////////////////////////////////
AGC_API unsigned int APIENTRY WXP_WriteMemByte(i16 CardNum, u32 Offset, u8 Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;
  
  if(Offset > (MEMSIZE-1))
  return ERRMSG(ERROR_API_WRITEMEMBYTE,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_WRITEMEMBYTE,ERROR_GEN_DEVICE_NUM); 
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_WRITEMEMBYTE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = Offset;
  ioAcce.value.byte = Value;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_MMW_BYTE, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if ( !error )
    return ERRMSG(ERROR_API_WRITEMEMBYTE,ERROR_GEN_DEVICE_FAIL);  
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_WriteMemWord(i16 CardNum, u32 Offset, u16 Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( Offset & 0x01) || (Offset > (MEMSIZE-2)))
  return ERRMSG(ERROR_API_WRITEMEMWORD,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_WRITEMEMWORD,ERROR_GEN_DEVICE_NUM);  
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_WRITEMEMWORD,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = Offset;
  ioAcce.value.word = Value;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_MMW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if ( !error )
    return ERRMSG(ERROR_API_WRITEMEMWORD,ERROR_GEN_DEVICE_FAIL);  
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_WriteMemDWord(i16 CardNum, u32 Offset, u32 Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if((Offset & 0x03) || (Offset > (MEMSIZE-4)))
  return ERRMSG(ERROR_API_WRITEMEMDWORD,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_WRITEMEMDWORD,ERROR_GEN_DEVICE_NUM); 
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_WRITEMEMDWORD,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = Offset;
  ioAcce.value.dword = Value;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_MMW_DWRD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if ( !error )
    return ERRMSG(ERROR_API_WRITEMEMDWORD,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}


AGC_API unsigned int APIENTRY WXP_ReadMemByte(i16 CardNum, u32 Offset, u8* Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(Offset > (MEMSIZE-1))
  return ERRMSG(ERROR_API_READMEMBYTE,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_READMEMBYTE,ERROR_GEN_DEVICE_NUM); 
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_READMEMBYTE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = Offset;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_MMR_BYTE, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if ( !error )
    return ERRMSG(ERROR_API_READMEMBYTE,ERROR_GEN_DEVICE_FAIL); 
  (*Value) = ioAcce.value.byte;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_ReadMemWord(i16 CardNum, u32 Offset, u16* Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if( ( Offset & 0x01) || (Offset > (MEMSIZE-2)))
  return ERRMSG(ERROR_API_READMEMWORD,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_READMEMWORD,ERROR_GEN_DEVICE_NUM);  
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_READMEMWORD,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = Offset;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_MMR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if ( !error )
    return ERRMSG(ERROR_API_READMEMWORD,ERROR_GEN_DEVICE_FAIL);  
  (*Value) = ioAcce.value.word;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_ReadMemDWord(i16 CardNum, u32 Offset, u32* Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if((Offset & 0x03) || (Offset > (MEMSIZE-4)))
  return ERRMSG(ERROR_API_READMEMDWORD,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_READMEMDWORD,ERROR_GEN_DEVICE_NUM);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_READMEMDWORD,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = Offset;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_MMR_DWRD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if ( !error )
    return ERRMSG(ERROR_API_READMEMDWORD,ERROR_GEN_DEVICE_FAIL); 
  (*Value) = ioAcce.value.dword;
  return ERROR_API_SUCC;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
AGC_API unsigned int APIENTRY WXP_WriteMemBlock(i16 CardNum, u32 Offset, u8 *Value, u32 Size)
{
  u32 i;
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if( (Offset > (MEMSIZE-1)) || ((Offset + Size) > MEMSIZE) )
  return ERRMSG(ERROR_API_WRITEMEMBLOCK,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_WRITEMEMBLOCK,ERROR_GEN_DEVICE_NUM);  
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_WRITEMEMBLOCK,ERROR_GEN_DEVICE_OPEN);

  for(i=0;i < Size;i++)
  {
    ioAcce.offset = Offset + i;
    ioAcce.value.byte = *(Value+i);
    error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_MMW_BYTE, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
    if ( !error )
      return ERRMSG(ERROR_API_WRITEMEMBLOCK,ERROR_GEN_DEVICE_FAIL);  
  }
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_ReadMemBlock(i16 CardNum, u32 Offset, u8 *Value, u32 Size)
{
  u32 i;
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if((Offset > (MEMSIZE-1)) || ((Offset + Size) > MEMSIZE))
  return ERRMSG(ERROR_API_READMEMBYTE,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_READMEMBYTE,ERROR_GEN_DEVICE_NUM);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_READMEMBYTE,ERROR_GEN_DEVICE_OPEN);

  for(i=0 ; i < Size ; i++)
  {
    ioAcce.offset = Offset+i;
    error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_MMR_BYTE, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
    if ( !error )
      return ERRMSG(ERROR_API_READMEMBYTE,ERROR_GEN_DEVICE_FAIL);  
    *(Value + i) = ioAcce.value.byte;
  }
  return ERROR_API_SUCC;
}

/**********************************
  For Switch SRAM Mode
INPUT  : IO ADDRESS , MEM Mode  
OUTPUT : ERROR CODE
**********************************/
AGC_API unsigned int APIENTRY WXP_SwitchMemMode(i16 CardNum, i16 Mode)
{
  IO_ACCESS ioAcce;
  BOOL error;
  DWORD BytesReturned;

  if((Mode < 0) || (Mode > 1))
  return ERRMSG(ERROR_API_SWITCHMEMMODE,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SWITCHMEMMODE,ERROR_GEN_DEVICE_NUM);
  if (DevInfo[CardNum].is_device_open == FALSE)
  return ERRMSG(ERROR_API_SWITCHMEMMODE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = SRAM_MODE;
  ioAcce.value.byte = Mode&0x01;

  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_BYTE, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SWITCHMEMMODE,ERROR_GEN_DEVICE_FAIL);
  return ERROR_API_SUCC;
}

////////////////////////////////////////////////////////////////////////////////
/**********************************
  For READ PORT DATA 
INPUT  : IO ADDRESS , PORT ADDRESS 
OUTPUT : VALUE , ERROR CODE
**********************************/
AGC_API unsigned int APIENTRY WXP_ReadInputChannel(i16 CardNum, i16 ChannelNum, u8* Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  //test input prot or data
  if((ChannelNum < 0) || (ChannelNum > 11))
  return ERRMSG(ERROR_API_READINPUTCHANNEL,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_READINPUTCHANNEL,ERROR_GEN_DEVICE_NUM);// Not vlaid card number
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_READINPUTCHANNEL,ERROR_GEN_DEVICE_OPEN);// Device not open

  ioAcce.offset = GPI_DATA;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_READINPUTCHANNEL,0);
  (*Value) = (ioAcce.value.word & (1<<ChannelNum))? 1 : 0;	
  return ERROR_API_SUCC;     
}

AGC_API unsigned int APIENTRY WXP_SetInputMode (i16 CardNum, i16 ChannelNum, u8 Mode)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETINPUTMODE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETINPUTMODE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETINPUTMODE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_MODE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETINPUTMODE,ERROR_GEN_DEVICE_FAIL);
  if( Mode == 0)
    ioAcce.value.word &= ~(1<<ChannelNum);
  else
    ioAcce.value.word |= 1<<ChannelNum;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETINPUTMODE,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetInputMode (i16 CardNum, i16 ChannelNum, u8* Mode)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETINPUTMODE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETINPUTMODE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETINPUTMODE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_MODE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETINPUTMODE,ERROR_GEN_DEVICE_FAIL);
  if(ioAcce.value.word & (1<<ChannelNum))
  (*Mode)=1;
  else
  (*Mode)=0;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetDebounce(i16 CardNum, i16 ChannelNum, u8 Dtime)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if((ChannelNum < 0) || (ChannelNum > 11)) 
  return ERRMSG(ERROR_API_SETDEBOUNCE,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETDEBOUNCE,ERROR_GEN_DEVICE_NUM);// Not vlaid card number
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETDEBOUNCE,ERROR_GEN_DEVICE_OPEN);// Device not open

  ioAcce.offset = GPI_DBOUNCE + ChannelNum;
  ioAcce.value.byte = Dtime;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_BYTE, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETDEBOUNCE,ERROR_GEN_DEVICE_FAIL);
  return ERROR_API_SUCC;
}

/////////////////////////////////
AGC_API unsigned int APIENTRY WXP_GetDebounce(i16 CardNum, i16 ChannelNum, u8* Dtime)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETDEBOUNCE,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETDEBOUNCE,ERROR_GEN_DEVICE_NUM);// Not vlaid card number
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETDEBOUNCE,ERROR_GEN_DEVICE_OPEN);// Device not open

  ioAcce.offset = GPI_DBOUNCE + ChannelNum;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_BYTE, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETDEBOUNCE,ERROR_GEN_DEVICE_FAIL);
  (*Dtime) = ioAcce.value.byte;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetInputInterruptEnable(i16 CardNum, i16 ChannelNum, u8 Enable)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETINPUTINTERRUPTENABLE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETINPUTINTERRUPTENABLE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETINPUTINTERRUPTENABLE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_INT_ENABLE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETINPUTINTERRUPTENABLE,ERROR_GEN_DEVICE_FAIL);
  if(Enable==0)
  ioAcce.value.word &= ~(1<<ChannelNum);
  else
  ioAcce.value.word |= 1<<ChannelNum;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETINPUTINTERRUPTENABLE,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetInputInterruptEnable(i16 CardNum, i16 ChannelNum, u8* Enable)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;
  
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETINPUTINTERRUPTENABLE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETINPUTINTERRUPTENABLE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETINPUTINTERRUPTENABLE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_INT_ENABLE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETINPUTINTERRUPTENABLE,ERROR_GEN_DEVICE_FAIL);
  if(ioAcce.value.word & (1<<ChannelNum))
  (*Enable)=1;
  else
  (*Enable)=0;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetCounterTriggerType(i16 CardNum, i16 ChannelNum, u8 Type)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETCOUNTERTRIGGERTYPE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETCOUNTERTRIGGERTYPE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETCOUNTERTRIGGERTYPE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_TRIG_TYPE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETCOUNTERTRIGGERTYPE,ERROR_GEN_DEVICE_FAIL);
  if(Type==0)
  ioAcce.value.word &= ~(1<<ChannelNum);
  else
  ioAcce.value.word |= 1<<ChannelNum;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETCOUNTERTRIGGERTYPE,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetCounterTriggerType(i16 CardNum, i16 ChannelNum, u8* Type)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETCOUNTERTRIGGERTYPE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETCOUNTERTRIGGERTYPE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETCOUNTERTRIGGERTYPE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_TRIG_TYPE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETCOUNTERTRIGGERTYPE,ERROR_GEN_DEVICE_FAIL);
  if(ioAcce.value.word & (1<<ChannelNum))
  (*Type)=1;
  else
  (*Type)=0;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetCounterMode (i16 CardNum, i16 ChannelNum, u8 Type)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;
  
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETCOUNTERMODE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETCOUNTERMODE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETCOUNTERMODE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_AUTOCLEAR;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETCOUNTERMODE,ERROR_GEN_DEVICE_FAIL);
  if(Type==0)
  ioAcce.value.word &= ~(1<<ChannelNum);
  else
  ioAcce.value.word |= 1<<ChannelNum;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETCOUNTERMODE,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetCounterMode (i16 CardNum, i16 ChannelNum, u8* Type)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETCOUNTERMODE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETCOUNTERMODE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETCOUNTERMODE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_AUTOCLEAR;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETCOUNTERMODE,ERROR_GEN_DEVICE_FAIL);
  if(ioAcce.value.word & (1<<ChannelNum))
  (*Type)=1;
  else
  (*Type)=0;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetCounterTimeout (i16 CardNum, i16 ChannelNum, u16 Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;
  
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETCOUNTERTIMEOUT,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETCOUNTERTIMEOUT,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETCOUNTERTIMEOUT,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_TO + ChannelNum*2;
  ioAcce.value.word = Value;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETCOUNTERTIMEOUT,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetCounterTimeout (i16 CardNum, i16 ChannelNum, u16* Buffer)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;
  
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETCOUNTERTIMEOUT,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETCOUNTERTIMEOUT,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETCOUNTERTIMEOUT,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_TO + ChannelNum*2;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETCOUNTERTIMEOUT,ERROR_GEN_DEVICE_FAIL);
  (*Buffer) = ioAcce.value.word;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetCounterTimeoutBase (i16 CardNum, i16 ChannelNum, u8 Base)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETCOUNTERTIMEOUTBASE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETCOUNTERTIMEOUTBASE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETCOUNTERTIMEOUTBASE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_TO_BASE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETCOUNTERTIMEOUTBASE,ERROR_GEN_DEVICE_FAIL);
  ioAcce.value.word &= ~(1<<ChannelNum);  //Clear related Counter Timeout Base to 0
  ioAcce.value.word |= (Base&0x1)<<ChannelNum; //Set related Counter Timeout Base
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETCOUNTERTIMEOUTBASE,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetCounterTimeoutBase (i16 CardNum, i16 ChannelNum, u8* Base)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETCOUNTERTIMEOUTBASE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETCOUNTERTIMEOUTBASE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETCOUNTERTIMEOUTBASE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_TO_BASE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETCOUNTERTIMEOUTBASE,ERROR_GEN_DEVICE_FAIL);
  (*Base) = (ioAcce.value.word >> ChannelNum) & 0x01;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetCounterValue (i16 CardNum, i16 ChannelNum, u16* Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETCOUNTERVALUE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETCOUNTERVALUE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETCOUNTERVALUE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_COUNTER + ChannelNum*2;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETCOUNTERVALUE,ERROR_GEN_DEVICE_FAIL);
  (*Value) = ioAcce.value.word;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetCounterTarget (i16 CardNum, i16 ChannelNum, u16 Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETCOUNTERTARGET,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETCOUNTERTARGET,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETCOUNTERTARGET,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_TARGET + ChannelNum*2;
  ioAcce.value.word = Value;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)  
    return ERRMSG(ERROR_API_SETCOUNTERTARGET,ERROR_GEN_DEVICE_FAIL);
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetCounterTarget (i16 CardNum, i16 ChannelNum, u16* Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETCOUNTERTARGET,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETCOUNTERTARGET,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETCOUNTERTARGET,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPI_TARGET + ChannelNum*2;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETCOUNTERTARGET,ERROR_GEN_DEVICE_FAIL);
  (*Value) = ioAcce.value.word;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_WriteOutputChannel(i16 CardNum, i16 ChannelNum, u8 Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if((ChannelNum < 0) || (ChannelNum > 11))
  return ERRMSG(ERROR_API_WRITEOUTPUTCHANNEL,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_WRITEOUTPUTCHANNEL,ERROR_GEN_DEVICE_NUM);// Not vlaid card number
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_WRITEOUTPUTCHANNEL,ERROR_GEN_DEVICE_OPEN);// Device not open

  ioAcce.offset = GPO_DATA;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_WRITEOUTPUTCHANNEL,0);
  if(Value==0)
  ioAcce.value.word &= ~(1<<ChannelNum);
  else
  ioAcce.value.word |= 1<<ChannelNum;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_WRITEOUTPUTCHANNEL,0);
  return ERROR_API_SUCC;     
}

AGC_API unsigned int APIENTRY WXP_ReadOutputChannel (i16 CardNum, i16 ChannelNum, u8* Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if((ChannelNum < 0) || (ChannelNum > 11))
  return ERRMSG(ERROR_API_READOUTPUTCHANNEL,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_READOUTPUTCHANNEL,ERROR_GEN_DEVICE_NUM);// Not vlaid card number
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_READOUTPUTCHANNEL,ERROR_GEN_DEVICE_OPEN);// Device not open

  ioAcce.offset = GPO_DATA;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_READOUTPUTCHANNEL,0);
  (*Value) = (ioAcce.value.word & (1<<ChannelNum))? 1 : 0;	
  return ERROR_API_SUCC;     
}

AGC_API unsigned int APIENTRY WXP_SetOutputMode (i16 CardNum, i16 ChannelNum, u8 Mode)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETOUTPUTMODE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETOUTPUTMODE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETOUTPUTMODE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_MODE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETOUTPUTMODE,ERROR_GEN_DEVICE_FAIL);
  if( Mode == 0)
  ioAcce.value.word &= ~(1<<ChannelNum);
  else
  ioAcce.value.word |= 1<<ChannelNum;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETOUTPUTMODE,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetOutputMode (i16 CardNum, i16 ChannelNum, u8* Mode)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETOUTPUTMODE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETOUTPUTMODE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETOUTPUTMODE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_MODE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETOUTPUTMODE,ERROR_GEN_DEVICE_FAIL);
  if(ioAcce.value.word & (1<<ChannelNum))
  (*Mode)=1;
  else
  (*Mode)=0;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetPGState (i16 CardNum, i16 ChannelNum, u8 State)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETPGSTATE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETPGSTATE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETPGSTATE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_PG_RUN;
  ioAcce.value.word = 1<<ChannelNum;
  if( State == 0)
  ioAcce.offset = GPO_PG_STOP;
  else
  ioAcce.offset = GPO_PG_RUN;
  
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETPGSTATE,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetPGState (i16 CardNum, i16 ChannelNum, u8* State)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETPGSTATE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETPGSTATE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETPGSTATE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_PG_RUN;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETPGSTATE,ERROR_GEN_DEVICE_FAIL);
  if(ioAcce.value.word & (1<<ChannelNum))
  (*State)=1;
  else
  (*State)=0;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetPGInterruptEnable (i16 CardNum, i16 ChannelNum, u8 Enable)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETPGINTERRUPTENABLE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETPGINTERRUPTENABLE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETPGINTERRUPTENABLE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_INT_ENABLE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETPGINTERRUPTENABLE,ERROR_GEN_DEVICE_FAIL);
  if( Enable == 0)
  ioAcce.value.word &= ~(1<<ChannelNum);
  else
  ioAcce.value.word |= 1<<ChannelNum;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETPGINTERRUPTENABLE,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetPGInterruptEnable (i16 CardNum, i16 ChannelNum, u8* Enable)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETPGINTERRUPTENABLE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETPGINTERRUPTENABLE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETPGINTERRUPTENABLE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_INT_ENABLE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETPGINTERRUPTENABLE,ERROR_GEN_DEVICE_FAIL);
  if(ioAcce.value.word & (1<<ChannelNum))
  (*Enable)=1;
  else
  (*Enable)=0;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetPGBase (i16 CardNum, i16 ChannelNum, u8 Base)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETPGBASE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETPGBASE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETPGBASE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_PG_BASE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_DWRD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETPGBASE,ERROR_GEN_DEVICE_FAIL);
  ioAcce.value.dword &= ~(0x03<<(ChannelNum*2));  
  ioAcce.value.dword |= (Base&0x3)<<(ChannelNum*2); 
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_DWRD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETPGBASE,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetPGBase (i16 CardNum, i16 ChannelNum, u8* Base)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETPGBASE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETPGBASE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETPGBASE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_PG_BASE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_DWRD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETPGBASE,ERROR_GEN_DEVICE_FAIL);
  (*Base) =(u8) (ioAcce.value.dword >>( ChannelNum*2)) & 0x03;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetPGDuty (i16 CardNum, i16 ChannelNum, u8 High, u8 Low)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETPGDUTY,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETPGDUTY,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETPGDUTY,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_PG_HIGH + ChannelNum*2;
  ioAcce.value.byte = High;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_BYTE, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETPGDUTY,ERROR_GEN_DEVICE_FAIL);
  ioAcce.offset = GPO_PG_LOW + ChannelNum*2;
  ioAcce.value.byte = Low;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_BYTE, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETPGDUTY,ERROR_GEN_DEVICE_FAIL);
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetPGDuty (i16 CardNum, i16 ChannelNum, u8* High, u8* Low)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETPGDUTY,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETPGDUTY,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETPGDUTY,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_PG_HIGH + ChannelNum*2;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_BYTE, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETPGDUTY,ERROR_GEN_DEVICE_FAIL);
  (*High) = ioAcce.value.byte;
  ioAcce.offset = GPO_PG_LOW + ChannelNum*2;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_BYTE, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETPGDUTY,ERROR_GEN_DEVICE_FAIL);
  (*Low) = ioAcce.value.byte;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetPGCycle (i16 CardNum, i16 ChannelNum, u16 Cycle)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETPGCYCLE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETPGCYCLE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETPGCYCLE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_PG_CYCLE + ChannelNum*2;
  ioAcce.value.word = Cycle;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETPGCYCLE,ERROR_GEN_DEVICE_FAIL);
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetPGCycle (i16 CardNum, i16 ChannelNum, u16* Cycle)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETPGCYCLE,ERROR_GEN_DEVICE_NUM);  
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_GETPGCYCLE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETPGCYCLE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = GPO_PG_CYCLE + ChannelNum*2;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETPGCYCLE,ERROR_GEN_DEVICE_FAIL);
  (*Cycle) = ioAcce.value.word;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetTimerInterruptEnable (i16 CardNum, i16 TimerNum, u8 Enable)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETTIMERINTERRUPTENABLE,ERROR_GEN_DEVICE_NUM);  
  if(( TimerNum < 0 ) || ( TimerNum > 11 ))
  return ERRMSG(ERROR_API_SETTIMERINTERRUPTENABLE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETTIMERINTERRUPTENABLE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = TIMER_ENABLE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETTIMERINTERRUPTENABLE,ERROR_GEN_DEVICE_FAIL);
  if( Enable == 0)
  ioAcce.value.word &= ~(1<<TimerNum);
  else
  ioAcce.value.word |= 1<<TimerNum;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETTIMERINTERRUPTENABLE,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetTimerInterruptEnable (i16 CardNum, i16 TimerNum, u8* Enable)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETTIMERINTERRUPTENABLE,ERROR_GEN_DEVICE_NUM);  
  if(( TimerNum < 0 ) || ( TimerNum > 11 ))
  return ERRMSG(ERROR_API_GETTIMERINTERRUPTENABLE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETTIMERINTERRUPTENABLE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = TIMER_ENABLE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETTIMERINTERRUPTENABLE,ERROR_GEN_DEVICE_FAIL);
  if(ioAcce.value.word & (1<<TimerNum))
  (*Enable)=1;
  else
  (*Enable)=0;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetTimerBase (i16 CardNum, i16 TimerNum, u8 Base)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETTIMERBASE,ERROR_GEN_DEVICE_NUM);  
  if(( TimerNum < 0 ) || ( TimerNum > 11 ))
  return ERRMSG(ERROR_API_SETTIMERBASE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETTIMERBASE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = TIMER_BASE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETTIMERBASE,ERROR_GEN_DEVICE_FAIL);
  ioAcce.value.word &= ~(1<<TimerNum);  
  ioAcce.value.word |= (Base&0x1)<<TimerNum; 
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETTIMERBASE,ERROR_GEN_DEVICE_FAIL); 
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetTimerBase (i16 CardNum, i16 TimerNum, u8* Base)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETTIMERBASE,ERROR_GEN_DEVICE_NUM);  
  if(( TimerNum < 0 ) || ( TimerNum > 11 ))
  return ERRMSG(ERROR_API_GETTIMERBASE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETTIMERBASE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = TIMER_BASE;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETTIMERBASE,ERROR_GEN_DEVICE_FAIL);
  (*Base) = (u8)((ioAcce.value.dword >> TimerNum) & 0x01);
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetTimerValue (i16 CardNum, i16 TimerNum, u16 Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETTIMERVALUE,ERROR_GEN_DEVICE_NUM);  
  if(( TimerNum < 0 ) || ( TimerNum > 11 ))
  return ERRMSG(ERROR_API_SETTIMERVALUE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETTIMERVALUE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = TIMER_VAL + TimerNum*2;
  ioAcce.value.word = Value;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOW_WORD, &ioAcce, sizeof(IO_ACCESS), NULL, 0, &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_SETTIMERVALUE,ERROR_GEN_DEVICE_FAIL);
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetTimerValue (i16 CardNum, i16 TimerNum, u16* Value)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETTIMERVALUE,ERROR_GEN_DEVICE_NUM);  
  if(( TimerNum < 0 ) || ( TimerNum > 11 ))
  return ERRMSG(ERROR_API_GETTIMERVALUE,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETTIMERVALUE,ERROR_GEN_DEVICE_OPEN);

  ioAcce.offset = TIMER_VAL + TimerNum*2;
  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_IOR_WORD, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETTIMERVALUE,ERROR_GEN_DEVICE_FAIL);
  (*Value) = ioAcce.value.word;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetPG(i16 CardNum, i16 ChannelNum, u8 Base, u8 High, u8 Low, u16 Cycle)
{
  unsigned int result;
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETPG,ERROR_GEN_DEVICE_NUM);
  if(( ChannelNum < 0 ) || ( ChannelNum > 11 ))
  return ERRMSG(ERROR_API_SETPG,ERROR_GEN_INPUTFORMAT);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETPG,ERROR_GEN_DEVICE_OPEN);

  result = WXP_WriteOutputChannel(CardNum, ChannelNum, 0);
  if(result !=0)  return result;
  WXP_SetPGInterruptEnable(CardNum, ChannelNum, 1);
  if(result !=0)  return result;
  WXP_SetPGState(CardNum, ChannelNum, 0);
  if(result !=0)  return result;
  WXP_SetOutputMode(CardNum, ChannelNum, 1);
  if(result !=0)  return result;
  WXP_SetPGBase(CardNum, ChannelNum, Base);
  if(result !=0)  return result;
  WXP_SetPGDuty(CardNum, ChannelNum, High, Low);
  if(result !=0)  return result;
  WXP_SetPGCycle(CardNum, ChannelNum, Cycle);
  if(result !=0)  return result;
  WXP_SetPGState(CardNum, ChannelNum, 1);
  if(result !=0)  return result;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_SetCallbackFunc(i16 CardNum, agc_callback_t func)
{
  DWORD ThreadId;
	HANDLE hThread;
  
  if(func == NULL)
  return ERRMSG(ERROR_API_SETCALLBACKFUNC,ERROR_GEN_INPUTFORMAT);
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_SETCALLBACKFUNC,ERROR_GEN_DEVICE_NUM);
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_SETCALLBACKFUNC,ERROR_GEN_DEVICE_OPEN);

	if (DevInfo[CardNum].is_thread_start == 0)
	{
    DevInfo[CardNum].CallBackFunc = func;
    hThread = CreateThread(0, 0, (LPTHREAD_START_ROUTINE)InterruptThread, (void*)&DevInfo[CardNum], 0, &ThreadId);
	}
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetEventCounter(i16 CardNum, u16* Count)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;

  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETEVENTCOUNTER,ERROR_GEN_DEVICE_NUM);  
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETEVENTCOUNTER,ERROR_GEN_DEVICE_OPEN);

  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_GET_CONT, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETEVENTCOUNTER,ERROR_GEN_DEVICE_FAIL);
  (*Count) = ioAcce.value.word;
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_GetEventBuffer(i16 CardNum, event* Event)
{
  BOOL error;
  IO_ACCESS ioAcce;
  DWORD BytesReturned;
  u16 type;
  
  if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
  return ERRMSG(ERROR_API_GETEVENTBUFFER,ERROR_GEN_DEVICE_NUM);  
  if( DevInfo[CardNum].is_device_open == FALSE )
  return ERRMSG(ERROR_API_GETEVENTBUFFER,ERROR_GEN_DEVICE_OPEN);

  error = DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_GET_BUFF, &ioAcce, sizeof(IO_ACCESS), &ioAcce, sizeof(IO_ACCESS), &BytesReturned, NULL);
  if (!error)
    return ERRMSG(ERROR_API_GETEVENTBUFFER,ERROR_GEN_DEVICE_FAIL);
  type = (u16)((ioAcce.value.dword) >> 16);
  if( type < INPUT_NO )
  {
    Event->Type = INPUT;
    Event->Channel = type;
  } else if( type < (INPUT_NO+OUTPUT_NO) )
  {
    Event->Type = PG_FIN;
    Event->Channel = type - INPUT_NO;
  } else if( type < (INPUT_NO+OUTPUT_NO+TIMER_NO) )
  {
    Event->Type = TIMER_FIN;
    Event->Channel = type - (INPUT_NO+OUTPUT_NO);
  } else if( type < 200 )
  {
    Event->Type = COUNTER_OF;
    Event->Channel = type - 100;
  } else if( type < 300 )
  {
    Event->Type = COUNTER_TO;
    Event->Channel = type - 200;
  } else
  {
    Event->Type = COUNTER_REACH;
    Event->Channel = type - 300;
  }
  Event->Value = (u16)(ioAcce.value.dword & 0x0000FFFF);
  return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_CanSendMessages(i16 CardNum, canmsg_t* buf, u8 count)
{
	DWORD written;
	int ret;
	if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
		return ERRMSG(ERROR_API_CANSENDMESSAGES,ERROR_GEN_DEVICE_NUM);  
	if( DevInfo[CardNum].is_device_open == FALSE )
		return ERRMSG(ERROR_API_CANSENDMESSAGES,ERROR_GEN_DEVICE_OPEN);
	ret = WriteFile(DevInfo[CardNum].drv_handle,buf,count*sizeof(canmsg_t),&written,NULL);
	//printf("ret = %d, written =%d\n", ret, written/sizeof(canmsg_t));
	return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_CanGetMessages(i16 CardNum, canmsg_t* buf, u8 count)
{
	DWORD read;
	int ret;
	if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
		return ERRMSG(ERROR_API_CANGETMESSAGES,ERROR_GEN_DEVICE_NUM);  
	if( DevInfo[CardNum].is_device_open == FALSE )
		return ERRMSG(ERROR_API_CANGETMESSAGES,ERROR_GEN_DEVICE_OPEN);
	ret = ReadFile(DevInfo[CardNum].drv_handle,buf,count*sizeof(canmsg_t),&read,NULL);
	//printf("ret = %d, read =%d\n", ret, read/sizeof(canmsg_t));
	return ERROR_API_SUCC;
}

AGC_API unsigned int APIENTRY WXP_CanConfig(i16 CardNum, int baud)
{
    BOOL error;
	Config_par_t can_config;
	Command_par_t can_cmd;
	DWORD BytesReturned;
	if(( CardNum < 0 ) || ( CardNum >= MAX_DEV ))
		return ERRMSG(ERROR_API_CANCONFIG, ERROR_GEN_DEVICE_NUM);  
	if( DevInfo[CardNum].is_device_open == FALSE )
		return ERRMSG(ERROR_API_CANCONFIG, ERROR_GEN_DEVICE_OPEN);

	if( (baud != 10) && (baud != 20) && (baud != 50) && (baud != 100) && (baud != 125) && (baud != 250) && (baud != 500) && 
		(baud != 800) && (baud != 1000) )
		return ERRMSG(ERROR_API_CANCONFIG, ERROR_GEN_INPUT_DATA);

	can_cmd.cmd = CMD_STOP;
    DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_CAN_COMMAND, &can_cmd, sizeof(Command_par_t), &can_cmd, sizeof(Command_par_t), &BytesReturned, NULL);

    can_config.target = CONF_TIMING; 
    can_config.val1   = baud;
    DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_CAN_CONFIG, &can_config, sizeof(Config_par_t), &can_config, sizeof(Config_par_t), &BytesReturned, NULL);

	can_cmd.cmd = CMD_START;
	DeviceIoControl(DevInfo[CardNum].drv_handle, (DWORD)ARBIOC_CAN_COMMAND, &can_cmd, sizeof(Command_par_t), &can_cmd, sizeof(Command_par_t), &BytesReturned, NULL);
	return ERROR_API_SUCC;
}
#ifdef _MANAGED
#pragma managed(pop)
#endif